#!/bin/bash
#
# Copyright (c) 2012-2015 Huawei .
# All rights reserved.
#
#
# Function
# revise note
######################################
set +x
WORK_PATH=$(cd "$(dirname "$BASH_SOURCE")";pwd)
source ${WORK_PATH}/ebackup_ms_profile.sh

G_HCP_ROOT=${G_HOME_PATH}
G_Micro_Service_Root=${G_HCP_ROOT}/microservice
G_Micro_Service="ebk_governance ebk_license ebk_alarm ebk_iam"
G_Micro_DB="ebk_license ebk_alarm ebk_iam ebk_governance"
G_HCP_CONFIG_INI="${G_ADMIN_CONF_FILE}"
G_PUBLIC_CONFIG_INI="${G_PUBLIC_CONF_FILE}"
G_TEE_TMP_NAME=${G_HCP_ROOT}"/tmp/retentionDbSql-tmp"
G_SECURITY_TOOL=$G_HCP_ROOT"/sbin/SecurityTool"
G_FULL_BACKUP_PATH=""
G_SOURCE_FULL_BACKUP_PATH=""
G_NEED_UMOUNT_DB_BAK=0
G_HCP_PROCESS_ACCOUNT=hcpprocess
G_MACHINE_ROLE="0"
G_ROLE_EBACKUP_SERVER="0"
G_ROLE_EBACKUP_MANAGER="2"
G_IS_UNIBACKUP=0
export LD_LIBRARY_PATH=${G_HCP_ROOT}/libs:${LD_LIBRARY_PATH}:${G_HCP_ROOT}/db/lib
export ODBCINI=${G_ROOT_PATH}/conf/odbc.ini
export ODBCSYSINI=${G_ROOT_PATH}/conf
source ${G_HCP_ROOT}/sbin/superlog.sh

declare -A ServiceArray
#############################################################
# Function: check_yes_or_no
# Description: 
# Parameter:
# input: input_info
#  	
# output: N/A
# Return:
# 0 -- input is "Y"
# 1 -- input is "N"
# 
#############################################################
function check_yes_or_no()
{
    local L_INPUT_INFO=$1
    local L_DEFAULT_SELECT=$2
    local L_YES_OR_NO=""
    
    while true
    do
        echo -ne "${L_INPUT_INFO}"
        read L_YES_OR_NO
        if [[ -z "${L_YES_OR_NO}" ]];then
            L_YES_OR_NO="${L_DEFAULT_SELECT}"
        fi

        if [[ "Y" == "$L_YES_OR_NO" || "y" == "${L_YES_OR_NO}" ]];then
            break;
        elif [[ "N" == "$L_YES_OR_NO" || "n" == "${L_YES_OR_NO}" ]];then
            break;
        else
            echo "Error input, please input 'y' or 'n'."
        fi
    done
    
    if [[ "Y" == "$L_YES_OR_NO" || "y" == "$L_YES_OR_NO" ]];then
        return 0
    else
        return 1
    fi
}

# Restore Admin DB
function RestoreAdminDB()
{
    log_info "restore admin database "
    sed -i '/^CREATE TABLE DUMMY.*($/,+2d' "$2"
    expect -f ${G_HCP_ROOT}/bin/access_db.exp "$1" "$2" "$3" "$4"
    local L_RET=$?
    if [ $L_RET -eq 0 ];then
        log_info "Restore DB success."
    else 
        log_info "Restore DB failed."
    fi 
    return $L_RET
}

# Restore WFCBS DB
function RestoreWfcbsDB()
{
    log_info "restore wfcbs database "
    expect -f ${G_HCP_ROOT}/bin/access_wfcbs_db.exp "$1" "$2" "$3" "$4"
    local L_RET=$?
    if [ $L_RET -eq 0 ];then
        log_info "Restore DB success."
    else 
        log_info "Restore DB failed."
    fi 
    return $L_RET
}
# Restore WFVMWARE DB
function RestoreWfvmwareDB()
{
    log_info "restore wfvmware database "
    expect -f ${G_HCP_ROOT}/bin/access_wfvmware_db.exp "$1" "$2" "$3" "$4"
    local L_RET=$?
    if [ $L_RET -eq 0 ];then
        log_info "Restore DB success."
    else 
        log_info "Restore DB failed."
    fi 
    return $L_RET
}

# Restore DATAMOVER DB
function RestoreDatamoverDB()
{
    log_info "restore datamover database "
    expect -f ${G_HCP_ROOT}/bin/access_datamover_db.exp "$1" "$2" "$3" "$4"
    local L_RET=$?
    if [ $L_RET -eq 0 ];then
        log_info "Restore DB success."
    else 
        log_info "Restore DB failed."
    fi 
    return $L_RET
}

function RestorelicenseDB()
{
    log_info "restore $5 database "
    expect -f ${G_HCP_ROOT}/bin/access_$5_db.exp "$1" "$2" "$3" "$4"
    local L_RET=$?
    if [ $L_RET -eq 0 ];then
        log_info "Restore DB success."
    else 
        log_info "Restore DB failed."
    fi 
    return $L_RET
}
function RestoregovernanceDB()
{
    log_info "restore $5 database "
    expect -f ${G_HCP_ROOT}/bin/access_$5_db.exp "$1" "$2" "$3" "$4"
    local L_RET=$?
    if [ $L_RET -eq 0 ];then
        log_info "Restore DB success."
    else 
        log_info "Restore DB failed."
    fi 
    return $L_RET
}

function sftp_err_msg()
{
    local e_Connect=7
    local e_Dir_NoExsit=9
    local e_Permission=25
    local e_No_Cert=60
    local e_Login=67
    local e_No_Space=70
    local e_No_File=78
    
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [ "$DBBakRepType" != "SFTP" ]
    then
        return 0
    fi
    local lcode=$1
    
    if [ $lcode -eq $e_Connect ]
    then
        echo -ne "\e[31mFailed to connect sftp server, IP or port is unreachable. Please confirm that the IP address and port settings are correct.\e[0m"
    elif [ $lcode -eq  $e_Dir_NoExsit ]
    then
        echo -ne "\e[31mFailed to connect to sftp server, target path does not exist or cannot access. Please confirm that the path setting is valid.\e[0m"
    elif [ $lcode -eq $e_Permission ]
    then
        echo -ne "\e[31mYou do not have permission to access the sftp server. Please confirm that current user have permission to access the sftp server.\e[0m"
    elif [ $lcode -eq  $e_No_Cert ]
    then
        echo -ne "\e[31mCannot find any matching CA certificate. Please import a valid CA certificiate for SFTP server.\e[0m"
    elif [ $lcode -eq $e_Login ]
    then
        echo -ne "\e[31mFailed to access the SFTP server, usr name or password is incorrect. Please confirm it.\e[0m"
    elif [ $lcode -eq $e_No_Space ]
    then
        echo -ne "\e[31mThere is not enough space available on SFTP server. Please confirm it.\e[0m"
    elif [ $lcode -eq $e_No_File ]
    then
        echo -ne "\e[31mThe file not exist on SFTP server. Please confirm it.\e[0m"
    fi
    echo ""
}

function ftp_err_msg()
{
    local e_Connect=7
    local e_Dir_NoExsit=9
    local e_Permission=25
    local e_No_Cert=60
    local e_Login=67
    local e_No_Space=70
    local e_No_File=78
    
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [ "$DBBakRepType" != "FTP" ] 
    then
        return 0
    fi
    local lcode=$1

    if [ $lcode -eq $e_Connect ]
    then
        echo -ne "\e[31mFailed to connect ftp server, IP or port is unreachable. Please confirm that the IP address and port settings are correct.\e[0m"
    elif [ $lcode -eq  $e_Dir_NoExsit ]
    then
        echo -ne "\e[31mFailed to connect to ftp server, target path does not exist or cannot access. Please confirm that the path setting is valid.\e[0m"
    elif [ $lcode -eq $e_Permission ]
    then
        echo -ne "\e[31mYou do not have permission to access the ftp server. Please confirm that current user have permission to access the ftp server.\e[0m"
    elif [ $lcode -eq  $e_No_Cert ]
    then
        echo -ne "\e[31mCannot find any matching CA certificate. Please import a valid CA certificiate for FTP server.\e[0m"
    elif [ $lcode -eq $e_Login ]
    then
        echo -ne "\e[31mFailed to access the FTP server, usr name or password is incorrect. Please confirm it.\e[0m"
    elif [ $lcode -eq $e_No_Space ]
    then
        echo -ne "\e[31mThere is not enough space available on FTP server. Please confirm it.\e[0m"
    elif [ $lcode -eq $e_No_File ]
    then
        echo -ne "\e[31mThe file not exist on FTP server. Please confirm it.\e[0m"
    fi
    echo ""
}
# Start GaussDB service
function StartAdminDB()
{
    log_info "StartAdminDB"
    /opt/huawei-data-protection/ebackup/bin/gaussdb_sandbox.sh start > /dev/null 2>&1
    local ret=$?
    if [ ${ret} -ne 0 ];then
        log_error "start db failed."
        return ${ret}
    fi
    local retrytimes=10
    while [ ${retrytimes} -gt 0 ]
    do
        sleep 1
        ps -ef | grep "gaussdb" | grep -v "grep" >> /dev/null 2>&1
        if [ $? -eq 0 ];then
            return 0
        fi
        retrytimes=$((${retrytimes} - 1))
    done
    
    log_error "start db failed."
    return 1
}

# Stop GaussDB service
function StopAdminDB()
{
    log_info "StopAdminDB"
    /opt/huawei-data-protection/ebackup/bin/gaussdb_sandbox.sh stop > /dev/null 2>&1
    return $?
}

#Check the role of current node.It must be proxy server.
function check_role()
{ 
    G_MACHINE_ROLE=$(grep '^MachineRole=' ${G_PUBLIC_CONFIG_INI} | awk -F'=' '{print $2}')
    
    if [[ "${G_MACHINE_ROLE}x" != "${G_ROLE_EBACKUP_SERVER}x" && "${G_MACHINE_ROLE}x" != "${G_ROLE_EBACKUP_MANAGER}x" ]];then
        echo "This operation must be done on backup server or backup manager. Please Contact Huawei technical support."
        exit 
    fi
}

function GetSelectFile()
{
    if [ ! -f $G_SECURITY_TOOL ];then
       echo "SecurityTool not exsit."
       log_error "SecurityTool not exsit, Operation aborted."       
       return  1
    fi
    
    if [ -L "${G_TEE_TMP_NAME}" ];then
        log_error "symbol link File."
        return 1
    fi
    $G_SECURITY_TOOL --RetentionDB -s "DESC" -d "${G_SOURCE_FULL_BACKUP_PATH}" | tee $G_TEE_TMP_NAME
    local printInfo=`grep 'select backup name' $G_TEE_TMP_NAME`
    rm $G_TEE_TMP_NAME
    NewDBFileName=${printInfo##*select backup name:}

    return 0
}

function GetSelectSubDir()
{
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    local PlugName=""
    if [[ "$DBBakRepType" == "NFS" || "$DBBakRepType" == "VIMS" || "$DBBakRepType" == "FTP" || "$DBBakRepType" == "SFTP" ]];then
        PlugName="SecurityTool"
    else
        PlugName=`grep "DBBackupPlugInName=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    fi 
    
    if [ ! -f ${G_HCP_ROOT}/sbin/${PlugName} ];then
       echo "${PlugName} not exsit."
       log_error "${PlugName} not exsit, Operation aborted."       
       return 1
    fi
    
    if [ -L "${G_TEE_TMP_NAME}" ];then
        log_error "symbol link File."
        return 1
    fi
    if [ "$G_IS_UNIBACKUP" = "1" ]
    then
        ${G_Micro_Service_Root}/ebk_mgr/bin/SecurityTool ListBackupsetDir | tee $G_TEE_TMP_NAME
    else
        $G_HCP_ROOT/sbin/${PlugName} ListBackupsetDir | tee $G_TEE_TMP_NAME
    fi
    local printInfo=`grep 'dir=' $G_TEE_TMP_NAME`
    local errCodeMsg=`grep 'FTP_ERR=' $G_TEE_TMP_NAME`
    local errCodeMsg_sftp=`grep 'SFTP_ERR=' $G_TEE_TMP_NAME`
    rm $G_TEE_TMP_NAME
    selectedBackupPath=${printInfo##*dir=}
    if [ $DBBakRepType == "FTP" ];then
        local errCode=${errCodeMsg##*FTP_ERR=}
        if [ "${selectedBackupPath}" == "" ];then
            log_error "There is no sub directory." 
            ftp_err_msg $errCode      
            return 2
        fi
    elif [ $DBBakRepType == "SFTP" ];then
        local errCode=${errCodeMsg_sftp##*SFTP_ERR=}
        if [ "${selectedBackupPath}" == "" ];then
            log_error "There is no sub directory." 
            sftp_err_msg $errCode      
            return 2
        fi
    fi
    if [[ $DBBakRepType == "FTP" || $DBBakRepType == "SFTP" ]]
    then
        selectedBackupPath=${selectedBackupPath##*/}
    fi
    if [[ "$DBBakRepType" == "NFS" || "$DBBakRepType" == "VIMS" ]];then
        G_SOURCE_FULL_BACKUP_PATH="${selectedBackupPath}"
    else
        G_SOURCE_FULL_BACKUP_PATH="${G_FULL_BACKUP_PATH}"
    fi 
    return 0
}

# download file from uds 
function DownloadFileByPlugIn()
{
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [[ "$DBBakRepType" == "VIMS" || "$DBBakRepType" == "NFS" ]];then
        if [ -f "$1" ];then
            return 0
        else
            echo "File $1 is not exist."
            return 3
        fi
    fi

    if [ $# -ne 2 ];then
        log_error "function DownloadFileByPlugIn() need two parameter unpack."
        return 1
    fi

    local lret=""
    local PlugName=`grep "DBBackupPlugInName=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [ "$DBBakRepType" == "FTP" ]
    then
        PlugName="SecurityTool"
        ${G_SECURITY_TOOL} DownloadFile $1 $2
        lret=$?
        ftp_err_msg $lret
        if [ 78 -eq $lret ]
        then
            lret=3
        fi
    fi
    if [ "$DBBakRepType" == "SFTP" ]
    then
        PlugName="SecurityTool"
        ${G_SECURITY_TOOL} DownloadSFTPFile $1 $2
        lret=$?
        sftp_err_msg $lret
        if [ 78 -eq $lret ]
        then
            lret=3
        fi
    fi
    if [ "$DBBakRepType" == "UDS" ]
    then
        ${G_HCP_ROOT}/sbin/${PlugName} DownloadFile $1 $2
        lret=$?
    fi
    
    return $lret
}

# download backu files
function DownloadBackupFile()
{
    local dbFileName=${selectedBackupPath}/RetentionDB.db
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [[ "$DBBakRepType" == "UDS" ]];then
        dbFileName=ebackup/${selectedBackupPath}/RetentionDB.db
    fi
    
    DownloadFileByPlugIn $dbFileName ${G_FULL_BACKUP_PATH}
    local re_db=$?
    if [ $re_db -ne 0 ];then
        echo "download DB file failed."
        return 1
    fi

    return 0
}

function SelectSubAndDownload()
{
    while true
    do
        GetSelectSubDir;ret=$?
        if [ $ret -ne 0 ];then
            echo "No sub directory exists."
            return 1
        fi
        local dbFileName=${selectedBackupPath}/RetentionDB.db
        local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
        if [[ "$DBBakRepType" == "UDS" ]];then
            dbFileName=ebackup/${selectedBackupPath}/RetentionDB.db
        fi
        
        DownloadFileByPlugIn ${dbFileName} ${G_FULL_BACKUP_PATH}
        local re_db=$?
        if [ $re_db -eq 3 ];then
            echo "RetentionDB is not exist, please choose again."
            continue
        elif [ $re_db -ne 0 ];then
            echo "download file failed."
        fi
        break
    done
    return 0
}

# download repository file
function DownloadRepFile()
{
    log_info "download repository file from remote."
    while true
    do
        GetSelectFile
        local dbFileName="${selectedBackupPath}"/"$NewDBFileName"
        local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
        if [[ "$DBBakRepType" == "UDS" ]];then
            dbFileName=ebackup/${selectedBackupPath}/"$NewDBFileName"
        fi
        DownloadFileByPlugIn $dbFileName $G_FULL_BACKUP_PATH;ret=$?
        if [ $ret -eq 3 ];then
            check_yes_or_no "\e[31mYou selected file is not exist, choose again? (y/n)\e[0m"
            if [ $? -eq 0 ];then
                continue
            else
                return 1
            fi
        elif [ $ret -ne 0 ];then
            echo "download file failed."
            continue
        fi
        break
    done
	
    mkdir "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcpmgr "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown $G_SOURCE_FULL_BACKUP_PATH/restore_tmp\e[0m"
        return 1
    fi
    tar -zxvf "$G_SOURCE_FULL_BACKUP_PATH"/"$NewDBFileName" -C "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mUnpackage backup file $G_SOURCE_FULL_BACKUP_PATH/$NewDBFileName field.\e[0m"
        return 1
    fi
    echo "Checking data..."
    tar -zxvf "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp/eBackup/verify.bin -C "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp/eBackup >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mUnpackage backup file $G_SOURCE_FULL_BACKUP_PATH/restore_tmp/eBackup/verify.bin field.\e[0m"
        return 1
    fi
    
    cp -r $G_SOURCE_FULL_BACKUP_PATH/restore_tmp/eBackup/kmc ${G_HCP_ROOT}/tmp >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp -r $G_SOURCE_FULL_BACKUP_PATH/restore_tmp/eBackup/kmc\e[0m"
        return 1
    fi
    if [ $G_IS_UNIBACKUP -eq 1 ];then
        $G_SECURITY_TOOL "--VerifyData"  "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp "../../../tmp/kmc" ;ret=$?
    else
        $G_SECURITY_TOOL "--VerifyData"  "$G_SOURCE_FULL_BACKUP_PATH"/restore_tmp "../tmp/kmc" ;ret=$?
    fi
    if [ $ret -eq 0 ];then
        return 0
    fi
    
    echo "Backup data...Correct."
    return 0
}

# delete download files 
function DelLocalFiles()
{
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [[ "${DBBakRepType}" == "VIMS" || "${DBBakRepType}" == "NFS" ]];then
        return 0
    fi

    rm -rf $* > /dev/null 2>&1

    return 0
}

#mount db_bak
function MountDBBak()
{
    #check type
    local L_DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    if [[ "${L_DBBakRepType}" != "VIMS" && "${L_DBBakRepType}" != "NFS" ]];then
        log_info "the DBBakRepositoryType is ${L_DBBakRepType}, no need mount."
        return 0
    fi
    
    #check whether mount
    local L_DBBackupDir=`grep "AdminDBBackupDir=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    mount | grep "${L_DBBackupDir}" >/dev/null 2>&1
    if [ 0 -eq $? ];then
        log_info "the db_bak already mounted."
        return 0
    fi
    
    G_NEED_UMOUNT_DB_BAK=1
    local L_DBBackupRemotePath=`grep "DBBakRepositoryRemotePath=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    local L_mount_ret=1
    if [[ "${L_DBBakRepType}" == "NFS" ]];then
        mount -t nfs -o vers=3,retry=1,retrans=20,soft,nolock,timeo=60 "${L_DBBackupRemotePath}" "${L_DBBackupDir}" > /dev/null 2>&1
        L_mount_ret=$?
    elif [[ "${L_DBBakRepType}" == "VIMS" ]];then
        L_VIMS_CLUSTER_NAME=""
        #online VIMS cluster
        if [ -f /etc/ocfs2/cluster.conf ];then
	    CHK_OCFS2=`lsmod | grep -w ocfs2`
            if [ $? -ne 0 ];then
                modprobe ocfs2
            fi
            L_VIMS_CLUSTER_NAME=`cat /etc/ocfs2/cluster.conf |grep  "name"|awk -F '=' '{print $2}' |sed 's/^ *//g'`
            if [ -z "${L_VIMS_CLUSTER_NAME}" ];then
                echo "There isn't vim cluster information."
                log_error "There isn't vim cluster information."
                return 1
            fi
            local L_LOOP_COUNT=3
            while [ $L_LOOP_COUNT -ne 0 ]
            do
                if [ -x /etc/init.d/o2cb.init  ];then
                    L_VMS_STATUS=`/etc/init.d/o2cb.init status ${L_VIMS_CLUSTER_NAME} |grep "Checking O2CB cluster"|awk -F ':' '{print $2}' |sed 's/^ *//g'`
                    if [ "X${L_VMS_STATUS}" == "XOnline" ];then
                        break
                    fi
                else
                    echo "Online ${L_VIMS_CLUSTER_NAME} failed."
                    log_error "Online ${L_VIMS_CLUSTER_NAME} failed."
                    return 1
                fi
                
                if [ -x /etc/init.d/o2cb.init  ];then
                    /etc/init.d/o2cb.init online ${L_VIMS_CLUSTER_NAME} > /dev/null 2>&1
                fi
                let L_LOOP_COUNT=$L_LOOP_COUNT-1
                sleep 20
            done
        else
            echo "There isn't vim cluster information."
            log_error "There isn't vim cluster information."
            return 1
        fi
        local L_MOUNT_CMD=`which mount.ocfs2`
        if [ ! -x ${L_MOUNT_CMD} ];then
            echo "Mount ${L_DBBackupRemotePath} to ${L_DBBackupDir} failed."
            log_error "mount.ocfs2 command not found"
            return 1
        fi
        ${L_MOUNT_CMD} -o novdilock ${L_DBBackupRemotePath} ${L_DBBackupDir} > /dev/null 2>&1
        L_mount_ret=$?
    fi
    
    if [ ${L_mount_ret} -ne 0 ];then
        echo "Mount ${L_DBBackupRemotePath} to ${L_DBBackupDir} failed."
        log_error "mount db_bak failed"
        return 1
    fi
}

#umount db_bak path
function UMountDBBak() 
{
    if [ 1 -eq ${G_NEED_UMOUNT_DB_BAK} ];then
        local L_DBBackupDir=`grep "AdminDBBackupDir=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
        umount -l "${L_DBBackupDir}" > /dev/null 2>&1
        if [ $? -ne 0 ];then
            log_warn "umount db_bak failed."
        fi
        return 0
    fi
    log_info "no need to umount db_bak."
}



function ModifyGaussConf()
{
    su gaussdb -s /bin/sh -c "export GAUSSDATA=${G_HCP_ROOT}/db/data;${G_HCP_ROOT}/db/bin/gs_guc reload -c password_reuse_time=0"
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to change password_reuse_time to zero\e[0m"
        return 1
    fi

    return 0
}

function RestoreGaussConf()
{
    su gaussdb -s /bin/sh -c "export GAUSSDATA=${G_HCP_ROOT}/db/data;${G_HCP_ROOT}/db/bin/gs_guc reload -c password_reuse_time=60"
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to change password_reuse_time to 60\e[0m"
        return 1
    fi

    return 0
}

function CheckHAStatus()
{
    local L_HA_MODE=$(sed -n 's/.*hamode.*value=\"\(.*\)\".*/\1/p' ${G_HCP_ROOT}/ha/module/hacom/conf/hacom.xml) 
    if [ "$L_HA_MODE" == "single" ];then
        log_warn "Single node will execute restore."
        return 0
    fi
   
    echo "ERROR: Restore is not allowed, because of HA is double mode." 

    exit 1
}
#1 target
#2 own
#3 mod
function set_permission()
{
    chown -h $2 $1
    if [ $? -ne 0 ];then
        echo -e "\e[0;31;1mError:Perfrom chown $2 $1 failed.\e[0m"
        return 1
    fi
    chmod $3 $1
    if [ $? -ne 0 ];then
        echo -e "\e[0;31;1mError:Perform chmod $3 $1 error,Please Contact Huawei technical support.\e[0m"
        return 1
    fi
}
function RestoreConfFiles()
{
    local DBBakRepType=`grep "DBBakRepositoryType=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    #restore dbkey
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/dbkey  ${G_HCP_ROOT}/conf >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/dbkey.\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/dbkey >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/dbkey\e[0m"
        return 1
    fi
    
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/AdminNode.pub  ${G_HCP_ROOT}/conf/cert/ >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/AdminNode.pub.\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/cert/AdminNode.pub >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/cert/AdminNode.pub\e[0m"
        return 1
    fi
    
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/AdminNode.secret  ${G_HCP_ROOT}/conf/cert/ >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/AdminNode.secret.\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/cert/AdminNode.secret >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/cert/AdminNode.secret\e[0m"
        return 1
    fi
    
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/BackupNode.pub  ${G_HCP_ROOT}/conf/cert/ >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/BackupNode.pub.\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/cert/BackupNode.pub >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/cert/BackupNode.pub\e[0m"
        return 1
    fi
    
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/BackupNode.secret  ${G_HCP_ROOT}/conf/cert/ >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/BackupNode.secret.\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/cert/BackupNode.secret >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/cert/BackupNode.secret\e[0m"
        return 1
    fi
	
    #restore kmc
    cp -r ${G_HCP_ROOT}/tmp/kmc  ${G_HCP_ROOT}/conf >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_HCP_ROOT}/tmp/kmc.\e[0m"
        return 1
    fi

    set_permission ${G_HCP_ROOT}/conf/kmc ${G_HCP_PROCESS_ACCOUNT}:hcp "750"
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/kmc.\e[0m"
        return 1
    fi

    #restore cacert
    cp -rP ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/cacert  ${G_HCP_ROOT}/conf >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/cacert.\e[0m"
        return 1
    fi

    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcpmgr ${G_HCP_ROOT}/conf/cacert >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/cacert.\e[0m"
        return 1
    fi

    #restore oc.crt
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/oc.crt  ${G_HCP_ROOT}/conf >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/oc.crt >/dev/null 2>&1

    #restore uds.crt
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/uds.crt  ${G_HCP_ROOT}/conf >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/uds.crt >/dev/null 2>&1
 
    #restore pwdModifystatus
    if [ -f "${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/pwdModifystatus" ];then
        cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/pwdModifystatus  ${G_HCP_ROOT}/conf >/dev/null 2>&1
        chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/pwdModifystatus >/dev/null 2>&1
        chmod 640 ${G_HCP_ROOT}/conf/pwdModifystatus >/dev/null 2>&1
    fi

    #restore udskey
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/udskey  ${G_HCP_ROOT}/conf >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/udskey >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/conf/udskey" ];then
        echo "symbol link File."
        return 1
    fi 
    chmod 600 ${G_HCP_ROOT}/conf/udskey >/dev/null 2>&1

    #restore ockey
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ockey  ${G_HCP_ROOT}/conf >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ockey.\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/ockey >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to chown ${G_HCP_ROOT}/conf/ockey\e[0m"
        return 1
    fi

    #restore ftpkey
    if [ -L "${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ftpkey" ];then
        echo "symbol link File."
        return 1
    fi
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ftpkey  ${G_HCP_ROOT}/conf >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/ftpkey >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/conf/ftpkey" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 600 ${G_HCP_ROOT}/conf/ftpkey >/dev/null 2>&1

    #restore sftpkey
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/sftpkey  ${G_HCP_ROOT}/conf >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/sftpkey >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/conf/sftpkey" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 600 ${G_HCP_ROOT}/conf/sftpkey >/dev/null 2>&1

    #restore cakey
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/cakey  ${G_HCP_ROOT}/conf >/dev/null 2>&1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcp ${G_HCP_ROOT}/conf/cakey >/dev/null 2>&1
    if [ -L "${G_HCP_ROOT}/conf/cakey" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 600 ${G_HCP_ROOT}/conf/cakey >/dev/null 2>&1

    #restore hcpconf.ini
    local L_FLOAT_IP=$(grep 'LoadbalanceAddress=' ${G_HCP_CONFIG_INI} | awk -F'//' '{print $2}')
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/hcpconf.ini  ${G_HCP_ROOT}/conf >/dev/null
    [ $? != 0 ] && return 1
    set_permission ${G_HCP_ROOT}/conf/hcpconf.ini ${G_HCP_PROCESS_ACCOUNT}:hcp  "640"

    if [ -L "${G_HCP_ROOT}/conf/hcpconf.ini" ];then
        echo "symbol link File."
        return 1
    fi

	sed -i "s/LoadbalanceAddress=https:\/\/.*/LoadbalanceAddress=https:\/\/${L_FLOAT_IP}/g" ${G_HCP_ROOT}/conf/hcpconf.ini >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to change IP to ${L_FLOAT_IP}\e[0m"
        return 1
    fi
    if [ -f "/etc/euleros-redhat-release" ];then
        sed -i "s/CurrentLeaderIP=.*/CurrentLeaderIP=${L_FLOAT_IP}/g" ${G_HCP_ROOT}/conf/hcpconf.ini >/dev/null
        if [ $? != 0 ];then
            echo -e "\e[31mfailed to change IP to ${L_FLOAT_IP}\e[0m"
            return 1
        fi
    else
    
        if [ -L "${G_HCP_ROOT}/conf/privateconf.ini" ];then
            echo "symbol link File."
            return 1
        fi
        local L_LOCAL_IP=$(cat ${G_HCP_ROOT}/conf/privateconf.ini |grep -e 'HCPInternalPlane=' | awk -F'=' '{print $2}' | awk -F'|' '{print $1}')
        sed -i "s/CurrentLeaderIP=.*/CurrentLeaderIP=${L_LOCAL_IP}/g" ${G_HCP_ROOT}/conf/hcpconf.ini >/dev/null
        if [ $? != 0 ];then
            echo -e "\e[31mfailed to change IP to ${L_LOCAL_IP}\e[0m"
            return 1
        fi
    fi
    
    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/secret.ini ${G_HCP_ROOT}/conf >/dev/null
    [ $? != 0 ] && return 1
    set_permission ${G_HCP_ROOT}/conf/secret.ini ${G_HCP_PROCESS_ACCOUNT}:hcp  "640"
    [ $? != 0 ] && return 1
    
    cp -rP ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/license ${G_HCP_ROOT} >/dev/null
    if [ $? != 0 ];then
        echo -e "\e[31mfailed to cp -r ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/license ${G_HCP_ROOT}\e[0m"
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcpmgr  ${G_HCP_ROOT}/license -R >/dev/null
    [ $? != 0 ] && return 1
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcpmgr  ${G_HCP_ROOT}/license/persisSafeMedia.txt >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/license/hypercert" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 730 ${G_HCP_ROOT}/license/hypercert >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/license/key.txt" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 600 ${G_HCP_ROOT}/license/key.txt >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/license/persisSafeMedia.txt" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 640 ${G_HCP_ROOT}/license/persisSafeMedia.txt >/dev/null 2>&1

    if [ -L "${G_HCP_ROOT}/license/trial.txt" ];then
        echo "symbol link File."
        return 1
    fi
    chmod 600 ${G_HCP_ROOT}/license/trial.txt >/dev/null 2>&1
    if [ -f ${G_HCP_ROOT}/license/license.inactive ]
    then
        if [ -L "${G_HCP_ROOT}/license/license.inactive" ];then
            echo "symbol link File."
            return 1
        fi
            
        rm ${G_HCP_ROOT}/license/license.inactive
    fi

    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/SSLEmail_client.cer ${G_HCP_ROOT}/conf >/dev/null 2>&1
    #restore ism

    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/httpd.conf  ${G_HCP_ROOT}/ism/Apache24/conf >/dev/null
    [ $? != 0 ] && return 1

    if [ -L "${G_HCP_ROOT}/ism/Apache24/conf/httpd.conf" ];then
        echo "symbol link File."
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcpmgr  ${G_HCP_ROOT}/ism/Apache24/conf/httpd.conf && chmod 600 ${G_HCP_ROOT}/ism/Apache24/conf/httpd.conf >/dev/null
    [ $? != 0 ] && return 1

    cp -P ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/httpd-ssl.conf  ${G_HCP_ROOT}/ism/Apache24/conf/extra >/dev/null
    [ $? != 0 ] && return 1

    if [ -L "${G_HCP_ROOT}/ism/Apache24/conf/extra/httpd-ssl.conf" ];then
        echo "symbol link File."
        return 1
    fi
    chown -h ${G_HCP_PROCESS_ACCOUNT}:hcpmgr  ${G_HCP_ROOT}/ism/Apache24/conf/extra/httpd-ssl.conf && chmod 600 ${G_HCP_ROOT}/ism/Apache24/conf/extra/httpd-ssl.conf >/dev/null
    [ $? != 0 ] && return 1

    return 0
}

function RestoreMicroService()
{
    for serviceName in ${G_Micro_Service}
    do
       local tmppath=$(echo ${G_Micro_Service_Root}/${serviceName})
       log_info "path=${tmppath}:${ServiceArray[*]}"
      
       local file_name=${ServiceArray["${serviceName}"]}
       log_info "file_name:${file_name}"
       local libPath="${LD_LIBRARY_PATH}"
       export LD_LIBRARY_PATH=${tmppath}/lib:$LD_LIBRARY_PATH 
       su -s /bin/bash hcpprocess -c "${tmppath}/bin/SecurityTool restore_microservice ${serviceName} ${file_name}"
       if [ $? -ne 0 ]
       then
           log_error "failed to restore ${serviceName} ${file_name}"
           echo -e "\e[31mfailed to restore ${serviceName} ${file_name}\e[0m"
           #this script run by user root, make sure hcpprocess user could access log file here
           chown -h hcpprocess:hcpmgr $tmppath/logs/metadata_oper.log
           export LD_LIBRARY_PATH="${libPath}"
           return 1
       fi
       export LD_LIBRARY_PATH="${libPath}"
       #this script run by user root, make sure hcpprocess user could access log file here
       chown -h hcpprocess:hcpmgr $tmppath/logs/metadata_oper.log
    done
}

function upload_micro_package()
{
    AccessDBTest
    if [ $? -ne 0 ]
    then
       log_error "failed to access microdb"
       echo -e "\e[31mfailed to access micro db \e[0m"
       return 1
    fi

    if [ -L "${G_TEE_TMP_NAME}" ];then
        log_error "symbol link File."
        return 1
    fi
    for serviceName in ${G_Micro_Service}
    do
       if [ ! -f ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/${serviceName}/${serviceName}.tar.gz ]
       then
           log_error "${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/${serviceName}/${serviceName}.tar.gz is not exist."
           return 1
       fi 
       local servicePrefixs="$(grep  -E "\sservice=\".*\"" "${G_Micro_Service_Root}/${serviceName}/conf/pluginmgr.xml" -o | sed "s@\sservice=\".*/@@g" | sed "s@\"@@g" | sed "s@\s@@g")";
       local uploadResult="fail";
       for servicePrefix in ${servicePrefixs}; 
       do
            ${G_SECURITY_TOOL} upload_package ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/${serviceName}/${serviceName}.tar.gz  ${servicePrefix} > $G_TEE_TMP_NAME 2>/dev/null
            if [ $? -ne 0 ]
            then
               log_error "failed to upload ${serviceName} according to service:${servicePrefix}"
               continue;
            fi
            log_info "success to upload file according service:${servicePrefix}"
            uploadResult="success";
            break;
       done
       if [ "${uploadResult}" == "fail" ]; then
            echo -e "\e[31mfailed to upload ${serviceName}\e[0m";
            return 1;
       fi
       
       local printinfo=`grep 'BackFileName is:' $G_TEE_TMP_NAME`
       echo $printinfo
       rm $G_TEE_TMP_NAME
       FILE_NAME=${printinfo##*BackFileName is:}
       log_info "file is ${FILE_NAME}"
       ServiceArray["${serviceName}"]="${FILE_NAME}"
   done
   log_info "array:[${ServiceArray[*]}]"
   return 0
}

function microservice_stop()
{
    local tmppath=""
    for serviceName in ${G_Micro_Service}
    do
        tmppath=$(echo ${G_Micro_Service_Root}/${serviceName}*)
        
        sh  "${tmppath}/script/ebackup_stop.sh" > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo -e "\e[31mfaied to stop service ${serviceName}\e[0m"
            log_error "faied to stop service ${serviceName}"
            return 1
        fi
    done
    unset EBACKUP_ROOT
    return 0
}

function RestoreMicroDB()
{
    local Name=""
    local L_DB_FILE_NAME=""
    
    for i in ${G_Micro_DB}
    do
        Name=${i##*_}
        L_DB_FILE_NAME=$(ls ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/${i}/${Name}.db)
        NewDBFileName="${L_DB_FILE_NAME}"
        if [ ! -f ${NewDBFileName} ]
        then
           log_error "RestoreMicroDB:[$Name]&[$NewDBFileName]"
           echo -e "\e[31m${Name}.db not exist\e[0m"
           return 1
        fi
        log_info "RestoreMicroDB:[$Name]&[$NewDBFileName]"
        local l_DBNAME=`tr '[a-z]' '[A-Z]' <<< "${Name}db"`
        RestorelicenseDB "${G_HCP_ROOT}" "${NewDBFileName}" "${l_DBNAME}" "ADMINDB_RESTORE" "${Name}"
        if [ $? -ne 0 ]
        then
            log_error "restore ${Name}.db failed."
            echo -e "\e[31mrestore ${Name}.db failed.\e[0m"
            return 1
        fi
    done
    return 0
}


#Add local access wfcbsdb privilege 
function AddWfcbsdbLocalPrivilege()
{
    if [ -L "${G_HCP_ROOT}/db/data/pg_hba.conf" ];then
        log_error "symbol link File."
        return 1
    fi
    echo "host  WFCBSDB  GAUSSDB,EBKDBUSER,EBKDBADMIN  127.0.0.1/32  sha256" >> ${G_HCP_ROOT}/db/data/pg_hba.conf
}
#Add local access wfvmwaredb privilege 
function AddWfvmwaredbLocalPrivilege()
{
    if [ -L "${G_HCP_ROOT}/db/data/pg_hba.conf" ];then
        log_error "symbol link File."
        return 1
    fi
    echo "host  WFVMWAREDB  GAUSSDB,EBKDBUSER,EBKDBADMIN  127.0.0.1/32  sha256" >> ${G_HCP_ROOT}/db/data/pg_hba.conf
}

#Add local access datamoverdb privilege 
function AddDatamoverdbLocalPrivilege()
{
    if [ -L "${G_HCP_ROOT}/db/data/pg_hba.conf" ];then
        log_error "symbol link File."
        return 1
    fi
    echo "host  DATAMOVERDB  GAUSSDB,EBKDBUSER,EBKDBADMIN  127.0.0.1/32  sha256" >> ${G_HCP_ROOT}/db/data/pg_hba.conf
}

#Del local access wfcbsdb privilege
function DelWfcbsdbLocalPrivilege()
{
    if [ -L "${G_HCP_ROOT}/db/data/pg_hba.conf" ];then
        log_error "symbol link File."
        return 1
    fi
    sed -i '/^host.* WFCBSDB .*127\.0\.0\.1.*/d' ${G_HCP_ROOT}/db/data/pg_hba.conf
}
#Del local access wfvmwaredb privilege
function DelWfvmwaredbLocalPrivilege()
{
    if [ -L "${G_HCP_ROOT}/db/data/pg_hba.conf" ];then
        log_error "symbol link File."
        return 1
    fi
    sed -i '/^host.* WFVMWAREDB .*127\.0\.0\.1.*/d' ${G_HCP_ROOT}/db/data/pg_hba.conf
}

#Del local access datamoverdb privilege
function DelDatamoverdbLocalPrivilege()
{
    if [ -L "${G_HCP_ROOT}/db/data/pg_hba.conf" ];then
        log_error "symbol link File."
        return 1
    fi
    sed -i '/^host.* DATAMOVERDB .*127\.0\.0\.1.*/d' ${G_HCP_ROOT}/db/data/pg_hba.conf
}

function ifdroptable()
{
    local trytime=10
    while [ $trytime -gt 0 ]
    do
        echo -n "This operation will drop the db, are you sure you want to continue?(y/n)"
        read ANS
        case $ANS in
        y|Y|yes|Yes)
            return 0
            ;;
        n|N|no|No)
            log_error "Operation aborted."
            return 1
            ;;
        *)
           echo "Error input, please input 'y' or 'n'."
           ;;
           esac
        trytime=$((trytime + 1))
    done
}
# Recover GaussDB
function RecoverGaussDB()
{
    CheckHAStatus
    ModifyGaussConf
    if [ $? -ne 0 ];then 
        log_error "modify gaussdb conf failed."
        return 1
    fi

    #Stop eBackup service
    log_info "stop eBackup service"
    service hcp stop
    if [ 0 -ne $? ]
    then
        echo "Failed: stop eBackup service failed."
        log_error "stop eBackup service failed"
        return 1
    else
        log_info "stop eBackup service success"   
    fi 
    log_info "check the db_bak whether or not mounted"
    MountDBBak
    if [ $? -ne 0 ];then 
        return 1
    fi
    log_info "ready to recover GaussDB"
    StartAdminDB
    if [ $? != 0 ];then 
        log_error "Start admin DB failed."
        echo "Start admin DB failed."
        return 1
    else
        log_info "Start admin DB success"  
    fi

    local L_DB_FILE_NAME=$(ls ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/*EBACKUP*\.db)
    NewDBFileName="${L_DB_FILE_NAME}"
    local num=`echo $NewDBFileName | awk '{print NF}'`
    if [ $num -ne 1 ]
    then
        echo "The admin.db have $num records."
        log_error "The admin.db have $num records."
        return 1
    fi

    if [ -z "$NewDBFileName" ] || [ ! -f ${NewDBFileName} ];then
        echo "No adminDB backup file found, or fail to access RetentionDB.db."
        chown -h hcpprocess:hcp ${G_SOURCE_FULL_BACKUP_PATH}/RetentionDB.db
        if [ $? -ne 0 ];then
            log_error "change RetentionDB.db owner failed."
            return 1
        fi
        
        #Check if to take an initial DB
        while true
        do
            echo -n "There is no backup of the DB, an initial (empty) DB will replace the current one, are you sure you want to continue?(y/n)"
            read ANS
            case $ANS in
            y|Y|yes|Yes)
                NewDBFileName="${BackupDBPath}/../db/initial_admin.db"
                if [ ! -f ${NewDBFileName} ];then
                    echo "The inital DB is not exist, restore failed."
                    log_error "The inital DB is not exist, restore failed."
                    return 1
                fi
                break;
                ;;
            n|N|no|No)
                echo "Operation aborted."
                log_error "Operation aborted."
                return 1
                ;;
            *)
                echo "Error input, please input 'y' or 'n'."
                ;;
            esac
        done

        if [ ! -f ${NewDBFileName} ]
        then
            echo "Initial DB file ${NewDBFileName} does not exist."
            log_error "Initial DB file ${NewDBFileName} does not exist."
            return 1
        fi
    fi 

    RestoreMicroService
    if [ $? -ne 0 ]
    then
        log_error "restore micro service failed."
        return 1
    fi
    ifdroptable
    if [ $? -ne 0 ]
    then
        log_info "Operate aborted."
        return 1
    fi

    RestoreAdminDB "${G_HCP_ROOT}" "${NewDBFileName}" "admindb" "admindb_restore"
    if [ $? != 0 ];then 
        log_error "Restore admin DB failed."
        echo "Restore DB failed."
        return 1
    else
        log_info "Restore admin DB success"
    fi

    RestoreMicroDB
    if [ $? != 0 ];then 
        log_error "Restore Micro DB failed."
        echo "Restore Micro DB failed."
        return 1
    else
        log_info "Restore Micro DB success"
    fi

    if [[ "${G_MACHINE_ROLE}x" == "${G_ROLE_EBACKUP_MANAGER}x" ]];then
        L_DB_FILE_NAME=$(ls ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ebk_openstack_vm/wfcbs.db)
        RestoreWfcbsDB "${G_HCP_ROOT}" "${L_DB_FILE_NAME}" "WFCBSDB" "ADMINDB_RESTORE"
        if [ $? -ne 0 ];then
            log_error "Restore WFCBS DB failed."
            echo "Restore WFCBS DB failed."
        else
            log_info "Restore WFCBS DB success."
        fi
        L_DB_FILE_NAME=$(ls ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ebk_openstack_vmware/wfvmware.db)
        RestoreWfvmwareDB "${G_HCP_ROOT}" "${L_DB_FILE_NAME}" "WFVMWAREDB" "ADMINDB_RESTORE"
        if [ $? -ne 0 ];then
            log_error "Restore WFVMWARE DB failed."
            echo "Restore WFVMWARE DB failed."
        else
            log_info "Restore WFVMWARE DB success."
        fi
    fi
     
    if [[ "${G_MACHINE_ROLE}x" == "${G_ROLE_EBACKUP_SERVER}x" ]];then
        echo "start restore datamoverdb"
        L_DB_FILE_NAME=$(ls ${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify/ebk_backup/datamover.db)
        RestoreDatamoverDB "${G_HCP_ROOT}" "${L_DB_FILE_NAME}" "DATAMOVERDB" "ADMINDB_RESTORE"
        if [ $? -ne 0 ];then
            log_error "Restore DATAMOVER DB failed."
            echo "Restore DATAMOVER DB failed."
        else
            log_info "Restore DATAMOVER DB success."
        fi
    fi
    
    ${G_SECURITY_TOOL} "change_admindb_passwd" "${G_HCP_ROOT}/conf" "${G_SOURCE_FULL_BACKUP_PATH}/restore_tmp/eBackup/verify"
    if [ $? -ne 0 ];then
        log_error "failed to change admin db passwd"
        echo -e "\e[31mfailed to change admin db passwd\e[0m"
        return 1
    fi
	
    RestoreGaussConf
    if [ $? -ne 0 ];then 
        log_error "restore gaussdb conf failed."
        return 1
    fi
	
    StopAdminDB
    if [ $? != 0 ];then 
        log_error "Stop admin DB failed."
        return 1 
    fi
    
    RestoreConfFiles
    if [ $? != 0 ];then 
        log_error "Restore configuration failes failed."
        return 1 
    fi
}


function AccessDBTest()
{
   for i in ${G_Micro_DB}
   do
       local tmppath=$(echo ${G_Micro_Service_Root}/${i}*)
       $G_SECURITY_TOOL  db_connect_test ${tmppath}/conf ${i}
       if [ $? -ne 0 ]
       then
          log_error "disconnect to microservice"
          echo -e "\e[31mcan not access ${i} db \e[0m"
          return 1 
       fi 
   done 
}
function KillMicroService()
{
    local -i ID=0
    local name=$1
    ID=$(echo `ps -ef|grep -v grep|grep ${name}$|awk '{print $2}'`)
    if [ "X" == "${ID}X" ]
    then
        return 0
    else
        kill -9 ${ID}
        if [ $? -eq 0 ]
        then
            return 0
        else
            return 1
        fi
    fi
    
}

function DoUpLoad()
{
    local BackupDBPath=`grep "AdminDBBackupDir=" ${G_HCP_CONFIG_INI} | awk -F"AdminDBBackupDir=" '{print $2}'`
    local DBBakSubDir=`grep "DBBakSubDir=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    G_FULL_BACKUP_PATH=${BackupDBPath}/$DBBakSubDir
    if [ "$G_IS_UNIBACKUP" = "1" ]
    then
        #下载统一备份存储上文件前，如果/opt/huawei-data-protection/ebackup/db_bak已被挂载，需要先卸载
        mount | grep -w "${BackupDBPath}" 1>/dev/null
        if [ $? -eq 0 ]
        then
            umount -l "${BackupDBPath}" > /dev/null 2>&1
            if [ $? -ne 0 ];then
                log_warn "umount db_bak failed."
                return 1
            fi
        fi
    fi
    log_info "download RetentionDB."
    SelectSubAndDownload
    [ $? != 0 ]&& return 1
    DownloadBackupFile
    [ $? != 0 ]&& return 1
    DownloadRepFile
    [ $? != 0 ]&& return 1
    
    DelLocalFiles $G_SOURCE_FULL_BACKUP_PATH/"$NewDBFileName"

    upload_micro_package
    if [ $? -ne 0 ]
    then
       log_error "upload microservice  failed."
       return 1
    fi
    return 0
}

function CatchSignal()
{
    local BackupDBPath=`grep "AdminDBBackupDir=" ${G_HCP_CONFIG_INI} | awk -F"AdminDBBackupDir=" '{print $2}'`
    local DBBakSubDir=`grep "DBBakSubDir=" ${G_HCP_CONFIG_INI} | awk -F "=" '{print $2}'`
    trap "DelLocalFiles $BackupDBPath/$DBBakSubDir/*;exit" 2
}

function Warning()
{
    while true
    do
        echo -n "WARNING: Restore DB will stop eBackup service, are you sure to continue?(y/n)"
        read ANS
        case $ANS in
        y|Y|yes|Yes)
            return 0
            ;;
        n|N|no|No)
            echo "Operation aborted."
            return 1
            ;;
        *)
            echo "Error input, please input 'y' or 'n'."
            ;;
        esac
    done
}
if [[ $# -eq 1 && $1 == "mgr" ]]; then
    G_IS_UNIBACKUP=1
    G_HCP_CONFIG_INI=${G_Micro_Service_Root}/ebk_mgr/conf/hcpconf.ini
    G_SECURITY_TOOL=${G_Micro_Service_Root}/ebk_mgr/bin/SecurityTool
    G_Micro_Service="ebk_governance ebk_license ebk_alarm ebk_iam"
    export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${G_Micro_Service_Root}/ebk_mgr/lib
fi

CatchSignal

Warning
if [ $? -ne 0 ]
then
    log_info "stop restore admin.db"
    exit 0
fi

DoUpLoad
if [ $? -ne 0 ]
then
   log_error "DoUpLoad Err"
   exit $?
fi

microservice_stop
if [ $? -ne 0 ]
then
    exit $?
fi

check_role
if [[ "${G_MACHINE_ROLE}x" == "${G_ROLE_EBACKUP_MANAGER}x" ]];then
    AddWfcbsdbLocalPrivilege       #Add local access wfcbsdb privilege
    AddWfvmwaredbLocalPrivilege    #Add local access wfvmwaredb privilege
fi

if [[ "${G_MACHINE_ROLE}x" == "${G_ROLE_EBACKUP_SERVER}x" ]];then
    AddDatamoverdbLocalPrivilege       #Add local access datamoverdb privilege
fi

RecoverGaussDB "$@";ret=$?

if [[ "${G_MACHINE_ROLE}x" == "${G_ROLE_EBACKUP_MANAGER}x" ]];then
    DelWfcbsdbLocalPrivilege       #Del local access wfcbsdb privilege
    DelWfvmwaredbLocalPrivilege    #Del local access wfvmwaredb privilege
fi

if [[ "${G_MACHINE_ROLE}x" == "${G_ROLE_EBACKUP_SERVER}x" ]];then
    DelDatamoverdbLocalPrivilege       #Del local access datamoverdb privilege
fi

rm -rf  "${G_HCP_ROOT}/tmp/kmc" > /dev/null 2>&1
rm -rf "$G_SOURCE_FULL_BACKUP_PATH/restore_tmp" > /dev/null 2>&1
DelLocalFiles $G_SOURCE_FULL_BACKUP_PATH/RetentionDB.db $NewDBFileName
UMountDBBak
if [ $ret -eq 0 ];then
    echo "Restore DB success."
else 
    StopAdminDB
    echo "Restore admin DB failed."
fi

service hcp start
if [ $? -ne 0 ]
then
   log_error "start hcp failed."
   echo "start hcp failed."
   exit 1
fi

exit $ret
